# FILE: LandMassesMapSize.py
# PURPOSE: A script for using LandMasses's map size generation.
# VERSION 1.0

# Import the required files.

import operator
from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import pickle
import math

#--------------------------------------------------------------------------------------------------------------------------#
# Predefined variables.
#--------------------------------------------------------------------------------------------------------------------------#

cachedMenuChoices = []
isamodule = False

#--------------------------------------------------------------------------------------------------------------------------#
# Step 1: Determine the map size.
#--------------------------------------------------------------------------------------------------------------------------#

def getGridSize(argsList, module = False):

        global isamodule

        if not module:
                isamodule = False
        elif module:
                isamodule = True

	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()
	saveSettings()

	# Determine what options have been selected.

	if isamodule:
                settings = open('LandMasses Map Size.cfg', 'r')
                SavedSettings = pickle.load(settings)
                Settings = []
                for Option in range(len(selection_names_and_values)):
                        for Choice in range(len(selection_names_and_values[Option])):
                                if SavedSettings[Option][1] == selection_names_and_values[Option][Choice][0]:
                                        Settings.append(selection_names_and_values[Option][Choice][1])
                                        break
                [Width, MaxWidth, Height, MaxHeight] = Settings
        elif not isamodule:
                Width = getSelectedMapValue("Min Width:")
                MaxWidth = getSelectedMapValue("Max Width:")
                Height = getSelectedMapValue("Min Height:")
                MaxHeight = getSelectedMapValue("Max Height:")

        # Determine the width of the grid.

        if (MaxWidth > 0 and MaxWidth != Width):
                DiffWidth = abs(MaxWidth - Width) + 1
                Width = min(Width, MaxWidth) + dice.get(DiffWidth, "Width")

        # Determine the height of the grid.

        if Height == 0:
                Height = int((Width*3.0)/5.0)
                MaxHeight = int((Width*5.0)/8.0)
                if MaxHeight != Height:
                        DiffHeight = abs(MaxHeight - Height) + 1
                        Height = min(Height, MaxHeight) + dice.get(DiffHeight, "Height")
        else:
                if (MaxHeight > 0 and MaxHeight != Height):
                        DiffHeight = abs(MaxHeight - Height) + 1
                        Height = min(Height, MaxHeight) + dice.get(DiffHeight, "Height")

        # Return the width and height.
	
	return (Width, Height)

#--------------------------------------------------------------------------------------------------------------------------#
# Step 2: Add additional menu options.
#--------------------------------------------------------------------------------------------------------------------------#

selection_titles = [unicode("Min Width:"),
                    unicode("Max Width:"),
                    unicode("Min Height:"),
                    unicode("Max Height:"),
                    ]

selection_names_and_values = [
        [
                ["16", 4],
                ["24", 6],
                ["32", 8],
                ["40 - Continents Duel", 10],
                ["48", 12],
                ["52 - Continents Tiny", 13],
                ["56", 14],
                ["64 - Continents Small", 16],
                ["72", 18],
                ["80", 20],
                ["84 - Continents Standard", 21],
                ["88", 22],
                ["96", 24],
                ["104 - Continents Large", 26],
                ["112", 28],
                ["120", 30],
                ["128 - Continents Huge", 32],
                ["136", 34],
                ["144", 36],
                ["152", 38],
                ["160", 40],
                ["168", 42],
                ["176", 44],
                ["184", 46],
                ["192", 48],
                ["200", 50],
                ["208", 52],
                ["216", 54],
                ["224", 56],
                ["232", 58],
                ["240", 60],
                ["248", 62],
                ["256", 64],
                ["264", 66],
                ["272", 68],
                ["280", 70],
                ["288", 72],
                ["296", 74],
                ["304", 76],
                ],
        [
                ["No variation", 0],
                ["16", 4],
                ["24", 6],
                ["32", 8],
                ["40 - Continents Duel", 10],
                ["48", 12],
                ["52 - Continents Tiny", 13],
                ["56", 14],
                ["64 - Continents Small", 16],
                ["72", 18],
                ["80", 20],
                ["84 - Continents Standard", 21],
                ["88", 22],
                ["96", 24],
                ["104 - Continents Large", 26],
                ["112", 28],
                ["120", 30],
                ["128 - Continents Huge", 32],
                ["136", 34],
                ["144", 36],
                ["152", 38],
                ["160", 40],
                ["168", 42],
                ["176", 44],
                ["184", 46],
                ["192", 48],
                ["200", 50],
                ["208", 52],
                ["216", 54],
                ["224", 56],
                ["232", 58],
                ["240", 60],
                ["248", 62],
                ["256", 64],
                ["264", 66],
                ["272", 68],
                ["280", 70],
                ["288", 72],
                ["296", 74],
                ["304", 76],
                ],
        [
                ["Normal width/height ratio", 0],
                ["16", 4],
                ["24 - Continents Duel", 6],
                ["32 - Continents Tiny", 8],
                ["40 - Continents Small", 10],
                ["48", 12],
                ["52 - Continents Standard", 13],
                ["56", 14],
                ["64 - Continents Large", 16],
                ["72", 18],
                ["80 - Continents Huge", 20],
                ["84", 21],
                ["88", 22],
                ["96", 24],
                ["104", 26],
                ["112", 28],
                ["120", 30],
                ["128", 32],
                ["136", 34],
                ["144", 36],
                ["152", 38],
                ["160", 40],
                ["168", 42],
                ["176", 44],
                ["184", 46],
                ["192", 48],
                ["200", 50],
                ["208", 52],
                ["216", 54],
                ["224", 56],
                ["232", 58],
                ["240", 60],
                ],
        [
                ["No variation", 0],
                ["16", 4],
                ["24 - Continents Duel", 6],
                ["32 - Continents Tiny", 8],
                ["40 - Continents Small", 10],
                ["48", 12],
                ["52 - Continents Standard", 13],
                ["56", 14],
                ["64 - Continents Large", 16],
                ["72", 18],
                ["80 - Continents Huge", 20],
                ["84", 21],
                ["88", 22],
                ["96", 24],
                ["104", 26],
                ["112", 28],
                ["120", 30],
                ["128", 32],
                ["136", 34],
                ["144", 36],
                ["152", 38],
                ["160", 40],
                ["168", 42],
                ["176", 44],
                ["184", 46],
                ["192", 48],
                ["200", 50],
                ["208", 52],
                ["216", 54],
                ["224", 56],
                ["232", 58],
                ["240", 60],
                ],
        ]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3: Further functions.
#--------------------------------------------------------------------------------------------------------------------------#

def isSeaLevelMap():
        return 0

def isRandomCustomMapOption(argsList):
        return False

def getDescription():
	return unicode("LandMasses Map Size")

def getNumCustomMapOptions():
	return len(selection_titles)

def getCustomMapOptionName(argsList):
	return selection_titles[argsList[0]]

def getSelectedMapValue(OptionName):
        
	gc = CyGlobalContext()
	cymap = CyMap()
	dice = gc.getGame().getMapRand()
	
	for Option in range(len(selection_titles)):
		if selection_titles[Option] == OptionName:
                        break
	
	Choice = int(cymap.getCustomMapOption(Option))
	
	if Choice >= len(selection_names_and_values[Option]):
		Choice = 0
				
	cachedMenuChoices[Option] = Choice
	
	return selection_names_and_values[Option][Choice][1]

def getNumCustomMapOptionValues(argsList):
        return len(selection_names_and_values[argsList[0]])

def getCustomMapOptionDescAt(argsList):
	return unicode(selection_names_and_values[argsList[0]][argsList[1]][0])

# Save selected map options.

def saveSettings():
        
        global isamodule

        if isamodule == True:
                return
    
	cymap = CyMap()
	settings = open('LandMasses Map Size.cfg', 'w')
	SavedSettings = []
	for Option in range(len(selection_titles)):
		Choice = int(cymap.getCustomMapOption(Option))
		ChoiceName = selection_names_and_values[Option][Choice][0]
		SavedSettings.append((selection_titles[Option], ChoiceName))
		
	print SavedSettings
	try:
		pickle.dump(SavedSettings, settings)
	except Exception, inst:
		print "    Pickling Error trying to save smartmap settings to LandMasses Map Size.cfg", inst
	settings.close()

# Find previously selected map options.

def getCustomMapOptionDefault(argsList):
	result = 0
	try:
		settings = open('LandMasses Map Size.cfg', 'r')
		SavedSettings = pickle.load(settings)
		for EachOption in range(len(SavedSettings)):
			Option, ChoiceName = SavedSettings[argsList[0]]
			if Option == selection_titles[argsList[0]]:
				for EachChoice in range(len(selection_names_and_values[argsList[0]])):
					EachChoiceName, EachChoiceValue = selection_names_and_values[argsList[0]][EachChoice]
					if EachChoiceName == ChoiceName:
						result = EachChoice
		settings.close()
	except IOError:
		print "    Couldn't find LandMasses Map Size.cfg"
	except EOFError:
		print "    Bad contents in LandMasses Map Size.cfg"
		
	return result

def isAdvancedMap():
	return 1

def beforeInit():
	global cachedMenuChoices
	cachedMenuChoices = []
	for Choice in range(len(selection_names_and_values)):
		cachedMenuChoices.append((0))
		
def beforeGeneration():
	global cachedMenuChoices
	for Choice in range(len(selection_names_and_values)):
		if selection_names_and_values[Choice][0] != "Wrap:":
			cachedMenuChoices[Choice] = 0

#--------------------------------------------------------------------------------------------------------------------------#
# Build Notes.
#--------------------------------------------------------------------------------------------------------------------------#

# Version 1.0:
# Seems to work as intended.
